% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/race-wrapper.R
\name{target_runner_default}
\alias{target_runner_default}
\title{Default \code{targetRunner} function.}
\usage{
target_runner_default(experiment, scenario)
}
\arguments{
\item{experiment}{A list describing the experiment. It contains at least:
\describe{
\item{\code{id_configuration}}{An alphanumeric string that uniquely identifies a configuration;}
\item{\code{id_instance}}{An alphanumeric string that uniquely identifies an instance;}
\item{\code{seed}}{Seed for the random number generator to be used for
this evaluation, ignore the seed for deterministic algorithms;}
\item{\code{instance}}{String giving the instance to be used for this evaluation;}
\item{\code{bound}}{(only when \code{capping} is enabled) Time bound for the execution;}
\item{\code{configuration}}{1-row data frame with a column per parameter
name;}
}}

\item{scenario}{\code{list()}\cr Data structure containing \pkg{irace}
settings. The data structure has to be the one returned by the function
\code{\link[=defaultScenario]{defaultScenario()}} or \code{\link[=readScenario]{readScenario()}}.}
}
\value{
If \code{targetEvaluator} is \code{NULL}, then the \code{targetRunner}
function must return a list with at least one element \code{"cost"},
the numerical value corresponding to the evaluation of the given
configuration on the given instance.

If the scenario option \code{maxTime} is non-zero or if \code{capping} is enabled
then the list must contain at least another element \code{"time"} that reports the
execution time for this call to \code{targetRunner}.
The return list may also contain the following optional elements that are used
by \pkg{irace} for reporting errors in \code{targetRunner}:
\describe{
\item{\code{error}}{is a string used to report an error;}
\item{\code{outputRaw}}{is a string used to report the raw output of calls to
an external program or function;}
\item{\code{call}}{is a string used to report how \code{targetRunner} called
an external program or function.}
}
}
\description{
Use it as an advanced example of how to create your own \code{targetRunner} function.
}
\author{
Manuel López-Ibáñez and Jérémie Dubois-Lacoste
}
