% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy-site.R
\name{deploy_site_github}
\alias{deploy_site_github}
\title{Deploy a pkgdown site on Travis-CI to Github Pages}
\usage{
deploy_site_github(
  pkg = ".",
  install = TRUE,
  tarball = Sys.getenv("PKG_TARBALL", ""),
  ssh_id = Sys.getenv("id_rsa", ""),
  commit_message = construct_commit_message(pkg),
  clean = FALSE,
  verbose = FALSE,
  host = "github.com",
  ...,
  repo_slug = Sys.getenv("TRAVIS_REPO_SLUG", "")
)
}
\arguments{
\item{pkg}{Path to package.}

\item{install}{Optionally, opt-out of automatic installation. This is
necessary if the package you're documenting is a dependency of pkgdown}

\item{tarball}{The location of the built package tarball. The default Travis
configuration for R packages sets \code{PKG_TARBALL} to this path.}

\item{ssh_id}{The private id to use, a base64 encoded content of the private
pem file. This should \emph{not} be your personal private key. Instead create a
new keypair specifically for deploying the site. The easiest way is to use
\code{travis::use_travis_deploy()}.}

\item{commit_message}{The commit message to be used for the commit.}

\item{clean}{Clean all files from old site.}

\item{verbose}{Print verbose output}

\item{host}{The GitHub host url.}

\item{...}{Additional arguments passed to \code{\link[=build_site]{build_site()}}.}

\item{repo_slug}{The \code{user/repo} slug for the repository.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

\code{deploy_site_github()} was designed to deploy your site from Travis CI,
which we no longer recommend, so this function is deprecated. There are
two replacements:
\itemize{
\item \code{\link[usethis:use_pkgdown]{usethis::use_pkgdown_github_pages()}} will setup a GitHub action to
automatically build and deploy your package website to GitHub pages.
\item \code{\link[=deploy_to_branch]{deploy_to_branch()}} can be called locally to build and deploy your
website to any desired branch.
}
}
\keyword{internal}
