/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.web3d.util.IntHashMap;

public class XMLTools {
    private static final String[][] BASIC_ARRAY = new String[][]{{"quot", "34"}, {"amp", "38"}, {"lt", "60"}, {"gt", "62"}};
    private static final String[][] APOS_ARRAY = new String[][]{{"apos", "39"}};
    public static final XMLTools XML = new XMLTools();
    EntityMap map = new LookupEntityMap();

    public void addEntities(String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addEntity(stringArray[i][0], Integer.parseInt(stringArray[i][1]));
        }
    }

    public void addEntity(String string, int n) {
        this.map.add(string, n);
    }

    public String entityName(int n) {
        return this.map.name(n);
    }

    public int entityValue(String string) {
        return this.map.value(string);
    }

    public String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string2 = this.entityName(c);
            if (string2 == null) {
                if (c > '\u007f') {
                    char c2 = c;
                    stringBuffer.append("&#");
                    stringBuffer.append((int)c2);
                    stringBuffer.append(';');
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('&');
            stringBuffer.append(string2);
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    public String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                int n;
                String string2;
                int n2;
                block14: {
                    n2 = string.indexOf(59, i + 1);
                    if (n2 == -1) {
                        stringBuffer.append(c);
                        continue;
                    }
                    string2 = string.substring(i + 1, n2);
                    if (string2.length() == 0) {
                        n = -1;
                    } else if (string2.charAt(0) == '#') {
                        if (string2.length() == 1) {
                            n = -1;
                        } else {
                            char c2 = string2.charAt(1);
                            try {
                                if (c2 == 'x' || c2 == 'X') {
                                    n = Integer.valueOf(string2.substring(2), 16);
                                    break block14;
                                }
                                n = Integer.parseInt(string2.substring(1));
                            }
                            catch (NumberFormatException numberFormatException) {
                                n = -1;
                            }
                        }
                    } else {
                        n = this.entityValue(string2);
                    }
                }
                if (n == -1) {
                    stringBuffer.append('&');
                    stringBuffer.append(string2);
                    stringBuffer.append(';');
                } else {
                    stringBuffer.append((char)n);
                }
                i = n2;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static {
        XML.addEntities(BASIC_ARRAY);
        XML.addEntities(APOS_ARRAY);
    }

    static class BinaryEntityMap
    extends ArrayEntityMap {
        public BinaryEntityMap() {
        }

        public BinaryEntityMap(int n) {
            super(n);
        }

        private int binarySearch(int n) {
            int n2 = 0;
            int n3 = this.size - 1;
            while (n2 <= n3) {
                int n4 = n2 + n3 >> 1;
                int n5 = this.values[n4];
                if (n5 < n) {
                    n2 = n4 + 1;
                    continue;
                }
                if (n5 > n) {
                    n3 = n4 - 1;
                    continue;
                }
                return n4;
            }
            return -(n2 + 1);
        }

        public void add(String string, int n) {
            this.ensureCapacity(this.size + 1);
            int n2 = this.binarySearch(n);
            if (n2 > 0) {
                return;
            }
            n2 = -(n2 + 1);
            System.arraycopy(this.values, n2, this.values, n2 + 1, this.size - n2);
            this.values[n2] = n;
            System.arraycopy(this.names, n2, this.names, n2 + 1, this.size - n2);
            this.names[n2] = string;
            ++this.size;
        }

        public String name(int n) {
            int n2 = this.binarySearch(n);
            if (n2 < 0) {
                return null;
            }
            return this.names[n2];
        }
    }

    static class ArrayEntityMap
    implements EntityMap {
        protected int growBy = 100;
        protected int size = 0;
        protected String[] names;
        protected int[] values;

        public ArrayEntityMap() {
            this.names = new String[this.growBy];
            this.values = new int[this.growBy];
        }

        public ArrayEntityMap(int n) {
            this.growBy = n;
            this.names = new String[n];
            this.values = new int[n];
        }

        public void add(String string, int n) {
            this.ensureCapacity(this.size + 1);
            this.names[this.size] = string;
            this.values[this.size] = n;
            ++this.size;
        }

        protected void ensureCapacity(int n) {
            if (n > this.names.length) {
                int n2 = Math.max(n, this.size + this.growBy);
                String[] stringArray = new String[n2];
                System.arraycopy(this.names, 0, stringArray, 0, this.size);
                this.names = stringArray;
                int[] nArray = new int[n2];
                System.arraycopy(this.values, 0, nArray, 0, this.size);
                this.values = nArray;
            }
        }

        public String name(int n) {
            for (int i = 0; i < this.size; ++i) {
                if (this.values[i] != n) continue;
                return this.names[i];
            }
            return null;
        }

        public int value(String string) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.names[i].equals(string)) continue;
                return this.values[i];
            }
            return -1;
        }
    }

    static class LookupEntityMap
    extends PrimitiveEntityMap {
        private String[] lookupTable;
        private int LOOKUP_TABLE_SIZE = 256;

        LookupEntityMap() {
        }

        public String name(int n) {
            if (n < this.LOOKUP_TABLE_SIZE) {
                return this.lookupTable()[n];
            }
            return super.name(n);
        }

        private String[] lookupTable() {
            if (this.lookupTable == null) {
                this.createLookupTable();
            }
            return this.lookupTable;
        }

        private void createLookupTable() {
            this.lookupTable = new String[this.LOOKUP_TABLE_SIZE];
            for (int i = 0; i < this.LOOKUP_TABLE_SIZE; ++i) {
                this.lookupTable[i] = super.name(i);
            }
        }
    }

    static class TreeEntityMap
    extends MapIntMap {
        public TreeEntityMap() {
            this.mapNameToValue = new TreeMap();
            this.mapValueToName = new TreeMap();
        }
    }

    static class HashEntityMap
    extends MapIntMap {
        public HashEntityMap() {
            this.mapNameToValue = new HashMap();
            this.mapValueToName = new HashMap();
        }
    }

    static abstract class MapIntMap
    implements EntityMap {
        protected Map mapNameToValue;
        protected Map mapValueToName;

        MapIntMap() {
        }

        public void add(String string, int n) {
            this.mapNameToValue.put(string, new Integer(n));
            this.mapValueToName.put(new Integer(n), string);
        }

        public String name(int n) {
            return (String)this.mapValueToName.get(new Integer(n));
        }

        public int value(String string) {
            Object v = this.mapNameToValue.get(string);
            if (v == null) {
                return -1;
            }
            return (Integer)v;
        }
    }

    static class PrimitiveEntityMap
    implements EntityMap {
        private Map mapNameToValue = new HashMap();
        private IntHashMap mapValueToName = new IntHashMap();

        PrimitiveEntityMap() {
        }

        public void add(String string, int n) {
            this.mapNameToValue.put(string, new Integer(n));
            this.mapValueToName.put(n, string);
        }

        public String name(int n) {
            return (String)this.mapValueToName.get(n);
        }

        public int value(String string) {
            Object v = this.mapNameToValue.get(string);
            if (v == null) {
                return -1;
            }
            return (Integer)v;
        }
    }

    static interface EntityMap {
        public void add(String var1, int var2);

        public String name(int var1);

        public int value(String var1);
    }
}

